<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Unset all session variables
$_SESSION = array();

// Destroy the session cookie
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time() - 3600, '/');
}

// Destroy auth token cookie
if (isset($_COOKIE['auth_token'])) {
    setcookie('auth_token', '', time() - 3600, '/', '', false, true);
}

// Destroy the session
session_destroy();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>خروج</title>
    <script>
        // پاک کردن Token از localStorage
        localStorage.removeItem('auth_token');
        localStorage.removeItem('user_data');
        
        // انتقال به صفحه اصلی
        window.location.href = '/';
    </script>
</head>
<body>
    <p>در حال خروج...</p>
</body>
</html>
